#set text(fill: rgb("#839496"))
#set page(
  width: 10in,
  height: 5.625in,
  margin: (top: 0.5in, bottom: 0.5in, left: 0.5in, right: 0.5in),
  fill: rgb("#002b36")
)
#set list()
#set heading(numbering: none)

// --- Slide 1: Title (FIXED: Powered By text, reduced spacing) ---
#align(center)[
  #text(4em, weight: "bold", fill: rgb("#2aa198"))[(Re)Building a Next-Gen]
  #text(4em, weight: "bold", fill: rgb("#2aa198"))[System Package Manager]
]
#v(0.3em)
#align(center)[
  #text(2.5em, fill: rgb("#2aa198"))[IPS, the Image Packaging System]
]
#v(1cm) // Reduced spacing

// Custom Title Slide content for Logo/Powered By
#align(center)[
  #text(1.2em, fill: rgb("#839496"))[Powered by] // Changed to just "Powered by"
  #v(0.1em)
  #image("./logo-final.svg", height: 2cm) // Increased logo size slightly for impact
  #v(0.5em)
  #text(1.5em, weight: "bold", fill: rgb("#839496"))[An Overview of IPS and its Concepts]
  #v(0.2em)
  #text(1.2em, fill: rgb("#839496"))[OpenIndiana Project]
]

// --- Slide 2: The Component That Fascinated Me (Legacy/Why IPS) ---
#pagebreak()
#align(center)[
  #text(2em, weight: "bold", fill: rgb("#2aa198"))[The Component That Fascinated Me]
  #line(length: 100%, stroke: 1pt + rgb("#2aa198"))
  #v(0.5em)
]
#align(center)[
  #text(1.5em, weight: "bold", fill: rgb("#2aa198"))[The OpenSolaris Legacy]
  #v(0.5em)
]
#list[
  A system born of innovation, designed for enterprise and stability.
  #linebreak()
  Key concepts: ZFS (CoW Filesystem), DTrace (Observability), Zones (Virtualization), Crossbow (Networking), SMF (Service Management).
  #linebreak()
  The Package Manager: Unlike anything before it.
]
#v(1em)
#align(center)[
  #text(1.5em, weight: "bold", fill: rgb("#2aa198"))[Why IPS? The SVR4 Problems]
]
#list[
  Stateful: Required complex, fragile scripts for upgrades.
  Non-Atomic: Failures could leave the system in an unrecoverable state.
  #linebreak()
  Image-Unaware: Treated the OS as a collection of loose files, not a coherent, managed image.
]

// --- Slide 3: The Genesis of IPS (History/Core Principle) ---
#pagebreak()
#align(center)[
  #text(2em, weight: "bold", fill: rgb("#2aa198"))[The Genesis of IPS]
  #line(length: 100%, stroke: 1pt + rgb("#2aa198"))
  #v(0.5em)
]
#align(center)[
  #text(1.5em, weight: "bold", fill: rgb("#2aa198"))[From SVR4 to the Modern Image]
  #v(0.5em)
]
#list[
  Goal: Create a package manager that treats the Operating System like a #text(fill: rgb("#2aa198"), weight: "bold")[bootable image], not just a set of archives.
  #linebreak()
  Creation Era: Developed by the OpenSolaris community and Sun Microsystems, deployed fully in Solaris 11 (c. 2011).
  #linebreak()
  Core Principle: #text(fill: rgb("#2aa198"), weight: "bold")[Repository-Centric Design.] The repository is the single source of truth for all system state and package metadata.
]
#v(1em)
#align(center)[
  #text(1.5em, weight: "bold", fill: rgb("#2aa198"))[What IPS Solved]
]
#list[
  Rollbacks: Integration with ZFS Boot Environments (BEs) makes package changes atomic and reversible.
  #linebreak()
  Dependency Hell: A sophisticated resolver that works against a precise, immutable record of every package version.
  #linebreak()
  Metadata: Shift from procedural (shell scripts) to declarative (manifests).
]

// --- Slide 4: FMRI - The Canonical Identity (FIXED: Table colors) ---
#pagebreak()
#align(center)[
  #text(2em, weight: "bold", fill: rgb("#2aa198"))[FMRI - The Canonical Identity]
  #line(length: 100%, stroke: 1pt + rgb("#2aa198"))
  #v(0.5em)
]
#align(center)[
  #text(1.5em, weight: "bold", fill: rgb("#2aa198"))[Fault Managed Resource Identifier (FMRI)]
  #v(0.5em)
]
#table(
  columns: (1fr, 2fr, 2fr), // Set columns to expand
  align: (center, center, left),
  stroke: 0.5pt + rgb("#839496"), // Lighter stroke for better readability
  fill: (row, col) => if row == 0 { rgb("#2aa198") } else { none },
  [#text(weight: "bold", fill: rgb("#002b36"))[Component]] , [#text(weight: "bold", fill: rgb("#839496"))[Example]] , 
  [#text(weight: "bold", fill: rgb("#839496"))[Role]],
  [#text(weight: "bold", fill: white)[Scheme]], [`pkg:`], [Always denotes an IPS entity.],
  [#text(weight: "bold", fill: white)[Publisher]], [`openindiana.org`], [Source and maintainer of the package.], // Fixed left column text color
  [#text(weight: "bold", fill: white)[Name]], [`/web/server/nginx`], [What the package #text(style: "italic")[is] (unique).], // Fixed left column text color
  [#text(weight: "bold", fill: white)[Version]], [`@1.25.3-...`], [#text(weight: "bold", fill: white)[Crucial:] Multiple version components. Software + build + branch + timestamp.],
)
#v(1em)
#align(center)[
  #text(1.5em, weight: "bold", fill: rgb("#2aa198"))[Why FMRI?]
]
#list[
  Immutability: Each FMRI is precise and globally unique.
  Rollback: Allows system to be reverted to a specific, known state.
  Precise Dependencies: Dependencies link to specific FMRIs, eliminating ambiguity.
]
#align(center)[
  #text(1.2em, fill: rgb("#2aa198"))[FMRI is the UUID of package management.]
]

// --- Slide 5: Self-Assembly - The Design Philosophy (FIXED: Use 1fr/1fr columns for even split) ---
#pagebreak()
#align(center)[
  #text(2em, weight: "bold", fill: rgb("#2aa198"))[Self-Assembly - The Design Philosophy]
  #line(length: 100%, stroke: 1pt + rgb("#2aa198"))
  #v(0.5em)
]
#align(center)[
  #text(1.5em, weight: "bold", fill: rgb("#2aa198"))[The Key Difference: The Image is Declared, Not Assembled during build ]
  #v(0.5em)
]
#columns(1, gutter: 1.5em)[
  #set list(indent: 0.5em)
  #text(1.2em, weight: "bold", fill: rgb("#2aa198"))[Traditional Approach]
  #list[
    Download a large, pre-built binary blob (archive).
    Unpack the onto the filesystem.
    Run scripts to configure.
  ]
  #v(0.5em)
  #align(center)[
    #text(fill: rgb("#dc322f"))[#text(weight: "bold")[Risk:] Conflicts only discovered *during* extraction/script run.]
    #linebreak()
    #text(fill: rgb("#dc322f"))[Not much better than running a .exe downloaded from the Internet as root]
  ]
  #set list(indent: 0.5em)
  #text(1.2em, weight: "bold", fill: rgb("#2aa198"))[IPS Self-Assembly Approach]
  #list[
    #text(weight: "bold")[Metadata-Centric:] Contents defined in a Manifest.
    #linebreak()
    #text(weight: "bold")[Image-Time Resolution:] Resolves the *entire* dependency graph *before* touching the system.
    #linebreak()
    #text(weight: "bold")[Atomic Operation:] The image (OS instance) is updated by pulling only the necessary file operations from the repository.
    #linebreak()
    #text(weight: "bold")[Integrated into ZFS:] The entire change is a single, atomic operation recorded as a new ZFS Boot Environment (BE).
  ]
]
#v(0.5em)
#align(center)[
  #text(1.2em, fill: rgb("#2aa198"), weight: "bold")[Result: Guaranteed success or a 100% reversible failure.]
]

// --- Slide 6: Facets and Variants (NEW SLIDE) ---
#pagebreak()
#align(center)[
  #text(2em, weight: "bold", fill: rgb("#2aa198"))[Configuration Control: Facets and Variants]
  #line(length: 100%, stroke: 1pt + rgb("#2aa198"))
  #v(0.5em)
]
#columns(1, gutter: 1.5em)[
  #text(1.5em, weight: "bold", fill: rgb("#2aa198"))[Facets (Optionality)]
  #list[
    #text(weight: "bold")[Definition:] Boolean properties for optional components.
    #linebreak()
    #text(weight: "bold")[Example:] `facet.doc.*`
    #linebreak()
    #text(weight: "bold")[How it Works:] Actions are conditionally included based on image settings.
    #linebreak()
    #text(weight: "bold")[Benefit:] Creates slim (production) or full (development) images.
  ]

  #text(1.5em, weight: "bold", fill: rgb("#2aa198"))[Variants (Choice)]
  #list[
    #text(weight: "bold")[Definition:] Properties that define mutually exclusive choices.
    #linebreak()
    #text(weight: "bold")[Example: `variant.arch=i386`]
    #linebreak()
    #text(weight: "bold")[Benefit:] A single package definition can cover multiple architectures/compilation targets (e.g., Zabbix for MySQL or PostgreSQL). 
  ]
]
#pagebreak()
#align(center)[
  #text(2em, weight: "bold", fill: rgb("#2aa198"))[Configuration Control: Mediators and Consolidations]
  #line(length: 100%, stroke: 1pt + rgb("#2aa198"))
  #v(0.5em)
]
#columns(1, gutter: 1.5em)[
  #text(1.5em, weight: "bold", fill: rgb("#2aa198"))[Mediators (Version/Implementation Switching)]
  #list[
    #text(weight: "bold")[Definition:] Mechanisms to indicate a preferred version when multiple are installed.
    #linebreak()
    #text(weight: "bold")[Example:] The image can contain both `gcc-10` and `gcc-12`, with a mediator pointing to the *active* version.
    #linebreak()
    #text(weight: "bold")[Benefit:] Enables safe, instantaneous switching between different versions of core components *within the same image*.
  ]
  #text(1.5em, weight: "bold", fill: rgb("#2aa198"))[Consolidations (System Integrity)]
  #list[
    #text(weight: "bold")[Definition:] Special, logical meta-packages that group related functional components (e.g., the core OS, a desktop environment, or a database stack).
    #linebreak()
    #text(weight: "bold")[Example:] consolidation/os/illumos-gate. Installing the consolidation ensures the entire associated subsystem is complete and maintained as one unit.
    #linebreak()
    #text(weight: "bold")[Benefit:] Guarantees system integrity and completeness across major functional areas, simplifying administrative updates and ensuring consistency by enforcing a single, known good state.
  ]
  #align(center)[
    #text(1.5em, weight: "bold", fill: rgb("#2aa198"))[Key Principle]
    #v(0.5em)
    #text(1.1em, fill: white)[Facets, Variants, and Mediators are set on the #text(weight: "bold")[Image] (the system), not the individual #text(weight: "bold")[Package].]
  ]
]

// --- Slide 8: The Future - IPS in Rust (pkg5) (FIXED: Layout) ---
#pagebreak()
#align(center)[
  #text(2em, weight: "bold", fill: rgb("#2aa198"))[The Future - IPS in Rust (pkg6)]
  #line(length: 100%, stroke: 1pt + rgb("#2aa198"))
  #v(0.5em)
]
#align(center)[
  #text(1.5em, weight: "bold", fill: rgb("#2aa198"))[(Re)Building for the Next Decade]
  #linebreak()
]
#columns(1, gutter: 1.5em)[
  #text(1.2em, weight: "bold", fill: rgb("#2aa198"))[Why Port to Rust?]
  #list[
    #text(weight: "bold")[Performance:] Move from C/Python implementation to a fast, with modern features.
    #linebreak()
    #text(weight: "bold")[Safety:] Eliminate large classes of bugs (memory management, concurrency) inherent in C. A package manager is system-critical. Compile it to one Static binary. 
    #linebreak()
    #text(weight: "bold")[Modernization:] Clean, maintainable codebase that attracts new FOSS contributors.
    #linebreak()
    #text(weight: "bold")[API:] Opportunity to design cleaner, more ergonomic APIs for integration.
  ]

  #text(1.2em, weight: "bold", fill: rgb("#2aa198"))[What Improvements Can We Make?]
  #list[
    #text(weight: "bold")[Algorithm:] Better dependency solver implementation (potentially leveraging modern SAT/SMT solvers).
    #linebreak()
    #text(weight: "bold")[Repository:] Enhanced metadata indexing and repository management performance.
    #linebreak()
    #text(weight: "bold")[Integration:] Easier integration with non-IPS tools and new OS features.
  ]
]
#v(0.5em)
#align(center)[
  #text(1.2em, fill: rgb("#2aa198"), weight: "bold")[Goal: Retain the elegant design of IPS while gaining the performance and safety of a modern implementation.]
]
